/*
 * Decompiled with CFR 0.152.
 */
package net.geforcemods.securitycraft.items.properties;

import net.geforcemods.securitycraft.SCContent;
import net.geforcemods.securitycraft.api.IDisguisable;
import net.geforcemods.securitycraft.api.IOwnable;
import net.geforcemods.securitycraft.components.CodebreakerData;
import net.geforcemods.securitycraft.items.properties.HitCheck;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;

public record CodebreakerState(HitCheck hitCheck) {
    public static final float DEFAULT = 0.0f;
    public static final float DECODING = 0.25f;
    public static final float FAILURE = 0.5f;
    public static final float SUCCESS = 0.75f;

    public float get(ItemStack stack, ClientLevel level, LivingEntity entity, int seed) {
        Player player;
        BlockHitResult hitResult;
        CodebreakerData codebreakerData = (CodebreakerData)stack.getOrDefault(SCContent.CODEBREAKER_DATA, (Object)CodebreakerData.DEFAULT);
        boolean isPlayer = entity instanceof Player;
        if ((!isPlayer || !((Player)entity).isCreative() && !((Player)entity).isSpectator()) && codebreakerData.wasRecentlyUsed()) {
            return codebreakerData.wasSuccessful() ? 0.75f : 0.5f;
        }
        if (level != null && isPlayer && (hitResult = HitCheck.getHitResult((Level)level, player = (Player)entity)) != null) {
            IOwnable ownable;
            BlockPos pos = hitResult.getBlockPos();
            BlockEntity be = level.getBlockEntity(pos);
            if (!(be instanceof IOwnable && (ownable = (IOwnable)be).isOwnedBy((Entity)player) || !IDisguisable.getDisguisedBlockState(be).isPresent())) {
                return 0.0f;
            }
            if (this.hitCheck.isValidHitResult((Level)level, hitResult)) {
                return 0.25f;
            }
        }
        return 0.0f;
    }
}

